// ForceCharIO.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#define ARRAY_SIZE(x)	(sizeof((x))/sizeof((x)[0]))

struct TerminationStruct
{
	HANDLE owner_process;
	HANDLE monitor_thread;
};

int main(int argc, char* argv[])
{
	DWORD error;

	PROCESS_INFORMATION process;
	STARTUPINFO startup;
	memset(&startup,0,sizeof(startup));
	startup.cb=sizeof(startup);
	startup.dwFlags=STARTF_USESTDHANDLES;
	startup.hStdInput=GetStdHandle(STD_INPUT_HANDLE);
	startup.hStdOutput=GetStdHandle(STD_OUTPUT_HANDLE);
	startup.hStdError=GetStdHandle(STD_ERROR_HANDLE);

	//Build a command line out of the arguments passed to this program
	TCHAR command_line[1024];
	command_line[0]=0;
	int i;
	for(i=1; i<argc; i++)
	{
		if(i > 1)
			StringCchCat(command_line, ARRAY_SIZE(command_line), TEXT(" "));
		StringCchCat(command_line, ARRAY_SIZE(command_line), argv[i]);
	}

	if(!_stricmp(command_line, "--help") ||
		!_stricmp(command_line, "-h") ||
		!_stricmp(command_line, "-?") ||
		!_stricmp(command_line, "/?") ||
		!_stricmp(command_line, ""))
	{
		fprintf(stderr, "Usage: %s <command line>\n\
Runs the given commandline, but forces the run program to think it is talking directly to a console (not a pipe or file).\n\
\n\
The reason someone would want to do that is because many programs will change their buffering policy depending on their output device. In some circumstances, that alternate buffering is undesired.\n\
\n\
As for how it actually works, it overloads the GetFileType() function so that it always returns FILE_TYPE_CHAR for stdin, stdout, and stderr. The Microsoft C runtime uses that function to determine whether or not the program is outputting to the console.\n\
", argv[0]);
		exit(1);
	}

	if(!CreateProcess(0,command_line,
		0,
		0,
		1,CREATE_SUSPENDED,0,0,&startup,&process))
	{
		error=GetLastError();
		if(error==2||error==3)
			printf("Could not find program %s\n",argv[1]);
		else
			printf("Could not create process %d\n",error);
		return -1;
	}

	HANDLE hproc=process.hProcess;
	TCHAR path[1000];
	char *exe_name;
	GetFullPathName(argv[0],1000,path,&exe_name);
	*exe_name=0;
	StringCchCat(path, ARRAY_SIZE(path), TEXT("GetFileTypeHook.dll"));
	int path_len=strlen(path)+1;

	//the follwing code is from http://malm.tuxfamily.org/src/injmod.c
	/* (1) Le pointeur sur la chaine de caractre doit tre valide : on alloue une zone 
	dans l'espace mmoire du processus cible et on y copie la chaine (cad le chemin complet
	de la DLL) 
	Attention, ici le pointeur path_remote n'est pas valide dans notre processus ! */
	char *path_remote=(char *)VirtualAllocEx(hproc, NULL, path_len, MEM_COMMIT, PAGE_READWRITE);
	if (path_remote==NULL)
	{
		printf("VirtualAllocEx()\n");
		return -1;
	}

	/* Copie de la chaine de caractres dans le processus cible */
	if (!WriteProcessMemory(hproc, path_remote, path, path_len, NULL))
	{
		printf("WriteProcessMemory()\n");
		return -1;
	}

	/*
	On cre un thread qui s'executera dans le contexte du processus cible.
	Le point d'entre du thread est LoadLibrary : par chance, cette fonction possde 
	un seul paramtre, tout comme le point d'entre d'un thread... On en profite pour 
	lui passer en paramtre l'adresse de la chaine contenant le chemin de notre DLL.
	
	(2) On doit tre sr que Kernel32 est bien mappe dans le process :  
	Kernel32 tant prsente dans tous les processus, a ne pose pas de problme.
	
	(3) Nous devons connaitre l'addresse de LoadLibrary dans le processus cible : 
	cette adresse dpend de l'endroit o Kernel32 a t mappe. L encore, pas de problme, 
	puisque Kernel32 est toujours mappe  la mme adresse (elle n'est jamais reloge) 
	
	Pour s'en convaincre :
	Creer un projet Visual C++, et le linker en changeant l'adresse de base
	(dans Project Settings > Link > Output > Base Address).
	Par dfaut, cette adresse est 0x400000 ; changez la en mettant l'adresse de base de kernel32
	(0x77e40000 chez moi). En lanant le process, un message d'erreur apparait :
	"Repositionnement de DLL systme non autoris"
	*/
	HANDLE file_mapping=CreateFileMapping(INVALID_HANDLE_VALUE,0,PAGE_READWRITE,
		0,sizeof(TerminationStruct),"ForceCharIOFileMapping");
	TerminationStruct *pass=(TerminationStruct *)MapViewOfFile(
		file_mapping,FILE_MAP_ALL_ACCESS,0,0,0);
	DuplicateHandle(GetCurrentProcess(),GetCurrentProcess(),hproc,&pass->owner_process,0,1,
		DUPLICATE_SAME_ACCESS);
	HANDLE hthread=CreateRemoteThread(hproc, NULL, 0, (PTHREAD_START_ROUTINE)LoadLibrary, path_remote, 0, NULL);
	if (hthread==NULL)
	{
		printf("CreateRemoteThread()\n");
		return -1;
	}

	/* On attend que le thread distant se termine */
	WaitForSingleObject(hthread, INFINITE);

	/* On rcupre le code de retour du thread, i.e. la valeur retourne
	par LoadLibrary : un handle (en d'autres termes, l'adresse de base) sur la DLL
	qui vient d'tre charge */
	DWORD hdll;
	GetExitCodeThread(hthread, &hdll);

	//printf("Handle de la DLL : 0x%x\n", hdll);

	/* Libration de la mmoire */
	VirtualFreeEx(hproc, path_remote, 0, MEM_RELEASE);

	CloseHandle(hthread);
	UnmapViewOfFile(pass);
	CloseHandle(file_mapping);

	ResumeThread(process.hThread);
	WaitForSingleObject(process.hProcess,INFINITE);
	DWORD exit_code;
	GetExitCodeProcess(process.hProcess,&exit_code);
	return exit_code;
}

