// GetFileTypeHook.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "GetFileTypeHook.h"
#include "apihijack.h"

HINSTANCE hDLL;
struct TerminationStruct
{
	HANDLE owner_process;
	HANDLE monitor_thread;
};

// Function pointer types.
typedef DWORD (WINAPI *GetFileType_Type)(HANDLE hFile);

// Function prototypes.
DWORD WINAPI MyGetFileType(HANDLE hFile);

// Hook structure.
enum
{
    KERNEL32FN_GetFileType = 0
};

SDLLHook KERNEL32Hook = 
{
    "KERNEL32.DLL",
    false, NULL,    // Default hook disabled, NULL function pointer.
    {
        { "GetFileType", MyGetFileType },
        { NULL, NULL }
    }
};

HANDLE stdin_handle;
HANDLE stdout_handle;
HANDLE stderr_handle;

// Hook function.
DWORD WINAPI MyGetFileType( HANDLE hFile)
{
    OutputDebugString( "GetFileTypeHook.dll: MyGetFileType called.\n" );
	if(hFile==stdin_handle||
		hFile==stdout_handle||
		hFile==stderr_handle)
	{
		OutputDebugString( "GetFileTypeHook.dll: It was a standard IO handle.\n" );
		return FILE_TYPE_CHAR;
	}

    GetFileType_Type OldFn = 
        (GetFileType_Type)KERNEL32Hook.Functions[KERNEL32FN_GetFileType].OrigFn;
    return OldFn( hFile );
}

DWORD WINAPI ExitOnParentClose(LPVOID param)
{
	HANDLE parent_process=(HANDLE)param;
	WaitForSingleObject(parent_process,INFINITE);
	OutputDebugString("Parent terminated\n");
	ExitProcess(-1);
	return (DWORD)-1;
}

BOOL __declspec( dllexport ) APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
        hDLL = (HINSTANCE)hModule;
		
        // We don't need thread notifications for what we're doing.  Thus, 
        // get rid of them, thereby eliminating some of the overhead of 
        // this DLL
        DisableThreadLibraryCalls( hDLL);
		stdin_handle=GetStdHandle(STD_INPUT_HANDLE);
		stdout_handle=GetStdHandle(STD_OUTPUT_HANDLE);
		stderr_handle=GetStdHandle(STD_ERROR_HANDLE);
		
		HookAPICalls( &KERNEL32Hook );

		{
			HANDLE file_mapping=OpenFileMapping(FILE_MAP_ALL_ACCESS,
				0,"ForceCharIOFileMapping");
			TerminationStruct *pass=(TerminationStruct *)MapViewOfFile(
				file_mapping,FILE_MAP_ALL_ACCESS,0,0,0);
			SECURITY_ATTRIBUTES inherit;
			inherit.nLength=sizeof(inherit);
			inherit.lpSecurityDescriptor=0;
			inherit.bInheritHandle=1;
			DWORD threadid;
			pass->monitor_thread=CreateThread(&inherit,0,ExitOnParentClose,pass->owner_process,0,&threadid);
			UnmapViewOfFile(pass);
			CloseHandle(file_mapping);
		}
		break;
	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
	case DLL_PROCESS_DETACH:
		break;
    }
    return TRUE;
}